function[A] = get_area(Q,c,f,new_geo)
%[A] = get_area(units,Q) returns the area, A, of the river
% cross section in question for each data point in Q, the flow data
% for the river.

h = c*Q^f;  %Mannings equation

%% Save the X and Y values of the x-section for ease of reference
Xxs = new_geo(:,1);
Yxs = new_geo(:,2);

%% Save the values of the new x and y maximums and minimums
xmin_new = min(Xxs);
ymin_new = min(Yxs);

xmax_new = max(Xxs);
ymax_new = max(Yxs);

%% some if statements to avoid some errors
if h == 0
    A = 0;
    return
end

if h > ymax_new
    h = ymax_new;
end

%% area algorithm

[Xo, Yo] = mminvinterp(Xxs,Yxs,h);

% This if statement accounts for the assumption that if the banks
% do not match, the side is taken as straight
if mod(length(Xo),2) ~= 0

    if find(Yxs == ymax_new) <= (length(Xxs)/3)
        Xo(end+1) = xmax_new;
        Yo(end+1) = h;
    elseif find(Yxs == ymax_new) >= (length(Xxs)/3)
        Xo = [0; Xo];
        Yo = [h; Yo];
    end %inner if

end %outer if

% figure(1)
% plot(new_geo(:,1),new_geo(:,2),'g',Xo,Yo,'ro')
% hold on

% This loop gets the width at each increment by summing the
% invidual differences in the Xo vector.
w=0;
for j=length(Xo):-2:2
    w = Xo(j) - Xo(j-1) + w;
end

% This loop will get the area under each depth increment and find the
% hydrolic radius at each increment
A_under_curve = 0;
P = 0;
for j=2:2:length(Xo)

    xo_start = min(find(Xxs>Xo(j-1)));
    xo_end   = max(find(Xxs<Xo(j)));

    x_temp(1) = Xo(j-1);
    x_temp(2) = Xxs(xo_start);
    y_temp(1) = Yo(j-1);
    y_temp(2) = Yxs(xo_start);

    p = xo_end - xo_start + 2;

    x_temp(p) = Xxs(xo_end);
    x_temp(p+1) = Xo(j);

    y_temp(p) = Yxs(xo_end);
    y_temp(p+1) = Yo(j);

    m=3;
    for k=(xo_start+1):1:(xo_end-1)
        x_temp(m) = Xxs(k);
        y_temp(m) = Yxs(k);
        m=m+1;
    end

    % Calculating the areas for each segment of the increment
    A_under_curve = trapz(x_temp,y_temp) + A_under_curve;

    % Must clear x and y temp so no old values remain for next j
    % iteration
    clear x_temp y_temp x_temp_mesh y_temp_mesh

end

%% Finally, the area of each section is the height increment multiplied
% by the width subtracted by the area under the curve
A = w*h - A_under_curve;